# Copyright (C) 2022 Mickaël Tansorier <mickael.tansorier@smile.fr>
# Released under the MIT license (see COPYING.MIT for the terms)

SUMMARY = "FDI Up base image"
DESCRIPTION = "Basique image for all FDI platform"
HOMEPAGE = "https://www.fdi-access.com"
LICENSE = "Proprietary"

inherit core-image

IMAGE_FSTYPES = "ext4 wic"

inherit overlayfs-root

IMAGE_FEATURES += "overlayfs-root"

IMAGE_INSTALL:append = " packagegroup-machine-base"
IMAGE_INSTALL:append = " packagegroup-core-boot"
IMAGE_INSTALL:append = " rauc"
IMAGE_INSTALL:append = " libubootenv-bin"

# needs kernel-image and device-tree in rootfs (/boot is included)
IMAGE_INSTALL:append = " kernel-devicetree kernel kernel-modules "

RDEPENDS_${KERNEL_PACKAGE_NAME}-base = "${KERNEL_PACKAGE_NAME}-image"

ROOTFS_POSTPROCESS_COMMAND += " \
"
