MFG_DIR = "${MACHINE}-manufacturing-${DATETIME}"
MFG_DIR_LINK = "${MACHINE}-manufacturing"

BUNDLE_NAME = "${MACHINE}-manufacturing-bundle"
#MFG_NAME = "${MFG_DIR}-${DATETIME}"
MFG_DIR[vardepsexclude] = "DATETIME"

do_generate_uuu_configuration() {
    UBOOT_HEX_SIZE_IN_SECTORS=$(printf "%X\n" $(stat -L -c %b ${DEPLOY_DIR_IMAGE}/${UBOOT_BINARY}))

    cat > uuu.auto<< EOF
uuu_version 1.4.193

#
# Main author:
#   John Madieu <john.madieu@gmail.com>
#

SDP: boot -f u-boot-with-spl.imx

#
# the '-chip' parameter allows uuu to find the right boot rom
# address. By not specifying this, you'll have the following error:
# 1:4      2/ 2 [run:659 can't get rom info            ] SDPU: jump -addr 0x177fffc0
#
# see file 'libuuu/rominfo.cpp' in uuu source code.
#
CFG: SDPU: -chip MX6D -vid 0x0525 -pid 0xb4a4
# SDPU: delay 1000

#
# /!\ Do not change the following addresses. These have been calculated according
# to our resulting u-boot binary image.
#
SDPV: write -f u-boot-with-spl.imx -addr 0x177eefc0
SDPV: jump -addr 0x177fffc0

#
# We could have used the following:
#FB: flash gw2v_mmc0boot0 u-boot-with-spl.imx
#FB: flash gw2v_mmc0boot1 u-boot-with-spl.imx
#
# but the 'flash' command does not accept offset on the target device.
# in this case, it starts flashing from 0x00, while the i.MX6 boot ROM expects
# the boot code at offset 0x400 (1KB)
#
# As a workarround, we download the file and use 'mmc write'

# As an example, we could have used the following command to change the fastboot
# buffer to another address by using the following:
#
# FB: ucmd setenv fastboot_buffer ${loadaddr}
#
# By not using it, we keep using the one spécified in 'CONFIG_FASTBOOT_BUF_ADDR'
# in board defconfig
FB: ucmd setenv fastboot_buffer 0x12c00000
FB: download -f u-boot-with-spl.imx

# select boot0 hw partition and flash it
FB: ucmd mmc dev 3 1
FB: ucmd mmc erase 0 0x4000
FB: ucmd mmc write \${fastboot_buffer} 0x2 0x${UBOOT_HEX_SIZE_IN_SECTORS}
# select boot2 hw partition and flash it
FB: ucmd mmc dev 3 2
FB: ucmd mmc erase 0 0x4000
FB: ucmd mmc write \${fastboot_buffer} 0x2 0x${UBOOT_HEX_SIZE_IN_SECTORS}

#
# To determine u-boot size in blocks
# SIZE=\$(stat -L -c %b \${DEPLOY_DIR_IMAGE}/\${UBOOT_IMAGE})
#
# Then to have this size in hex (mmc write consider everything as hex)
# printf "%X\n" \$(stat -L -c %b \${DEPLOY_DIR_IMAGE}/\${UBOOT_IMAGE})
#

# select boot1 hw partition as boot partition
#FB: ucmd mmc partconf \${mmcdev} 1 1 0
FB: ucmd mmc partconf 3 1 1 0

# Now flash the rootfs on user partition
FB: flash -raw2sparse gw2v_emmc mmc.img

# /!\ eFuse flashing is always critical
# Boot from eMMC (0x60)
# - blow 0x450[6] - BT_CFG1_6
# - blow 0x450[5] - BT_CFG1_5
FB: ucmd fuse prog -y 0 5 0x60

# Select uSDHC4 as boot device and in 8 bit mode (0x5800)
# - blow 0x450[11] - BT_CFG2_3
# - blow 0x450[12] - BT_CFG2_4
# - blow 0x450[14] - BT_CFG2_6
FB: ucmd fuse prog -y 0 5 0x5800

# Boot from efuse only
# - blow 0x460[4] - BT_FUSE_SEL
FB: ucmd fuse prog -y 0 6 0x10

#FB: acmd reset
FB: done
SDPU: done
EOF
}

do_manufacturing_bundle() {
    cd ${DEPLOY_DIR_IMAGE}

    install -m 755 -d ${MFG_DIR}
    install -m 755 -d ${MFG_DIR}/${BUNDLE_NAME}
    install -m 644 ${PN}-${MACHINE}.wic             ${MFG_DIR}/${BUNDLE_NAME}/mmc.img
    install -m 644 ${UBOOT_BINARY}                  ${MFG_DIR}/${BUNDLE_NAME}

    do_generate_uuu_configuration
    install -m 644 uuu.auto                         ${MFG_DIR}/${BUNDLE_NAME}

#    install -m 755 ${STAGING_BINDIR_NATIVE}/uuu     ${MFG_DIR}
    install -m 755 uuu     ${MFG_DIR}

    # let's create the bundle zip
    cd ${MFG_DIR} && zip -r -j ${BUNDLE_NAME}.zip . && cd - && rm -rf ${MFG_DIR}/${BUNDLE_NAME}
    ln -snf ${MFG_DIR} ${MFG_DIR_LINK}
}

addtask do_manufacturing_bundle before do_build after do_image_complete

IMAGE_FSTYPES += "wic"
EXTRA_IMAGEDEPENDS += " \
    virtual/bootloader \
    uuu-mfgtools-native \
    zip-native \
"

do_manufacturing_bundle[depends] += "uuu-mfgtools-native:do_install"
do_manufacturing_bundle[depends] += "${PN}:do_image_wic"
