# Recipe created by recipetool
# This is the basis of a recipe and may need further editing in order to be fully functional.
# (Feel free to remove these comments when editing.)

# Unable to find any files that looked like license statements. Check the accompanying
# documentation and source headers and set LICENSE and LIC_FILES_CHKSUM accordingly.
#
# NOTE: LICENSE is being set to "CLOSED" to allow you to at least start building - if
# this is not accurate with respect to the licensing of the software being built (it
# will not be in most cases) you must specify the correct value before using this
# recipe for anything other than initial testing/development!
LICENSE = "CLOSED"
LIC_FILES_CHKSUM = ""

DEPENDS = "		\
	jansson		\
	libyokisbus	\
	mosquitto	\
	librequirements	\
	libyokisotp	\
	liblog		\
"

RDEPENDS:${PN} = "		\
	       libyokisbus	\
	       liblog		\
		   curl			\
"

SRC_URI = " \
	git://${GITLAB_FDI}/embedded/yokis/SY029_Gateway_V6/src/yk-mqtt-integrator.git;protocol=ssh;branch=main \
	file://${BPN}.service \
"

SRCREV = "03f87013cc15902c9a34285794f0097da5abed8e"

S = "${WORKDIR}/git"

inherit meson pkgconfig systemd

# Remove header in SDK to avoid old .h during application development
TOOLCHAIN_TARGET_TASK:remove = "${BPN}-dev"
TOOLCHAIN_HOST_TASK:remove = "${BPN}-dev"

FILES:${PN} += " \
	${systemd_unitdir}/system/* \
	${sysconfdir_native}/yokis/mqtt/ \
	${sysconfdir_native}/ssl/certs/mqtt \
"

SYSTEMD_AUTO_ENABLE = "enable"
SYSTEMD_SERVICE:${PN} = "yk-mqtt-integrator.service"

do_install:append() {
	install -d ${D}${systemd_system_unitdir}/
	install -m 0644 ${WORKDIR}/yk-mqtt-integrator.service ${D}${systemd_system_unitdir}/

	# Add /etc/yokis/mqtt
	install -d ${D}${sysconfdir_native}/yokis/mqtt/

	# Add /etc/ssl/certs/mqtt
	install -d ${D}${sysconfdir_native}/ssl/certs/mqtt
}
