# Copyright (C) 2022 Mickaël Tansorier <mickael.tansorier@smile.fr>
# Released under the MIT license (see COPYING.MIT for the terms)

require recipes-core/images/image-fdi-base.bb

require recipes-core/images/users-yokis.inc

SUMMARY = "Yokis Gate Up base image"
DESCRIPTION = "Basique image for Yokis Gate Up platform"
HOMEPAGE = "https://www.yokis.com"

inherit yocto-cooker

IMAGE_FEATURES += "ssh-server-openssh"

IMAGE_INSTALL:append = " linux-firmware-nxp89xx"

# Yokis applications
IMAGE_INSTALL += " \
    yk-commander \
    yk-mqtt-integrator \
    yk-zigbee \
    yk-gpio-init \
    yk-led \
    yk-button \
    yk-syncconf \
    dms \
"

# Yokis V5 applications
IMAGE_INSTALL += " \
    yokisv5 \
"

# Use in hook
IMAGE_INSTALL += " \
    e2fsprogs-tune2fs \
    e2fsprogs-mke2fs \
"

# Wifi
IMAGE_INSTALL += " \
    connman \
    connman-client \
"

SOC_DEFAULT_WKS_FILE:mx8m-nxp-bsp = "yokis-gate-up.wks.in"
IMAGE_ROOTFS_SIZE = "524288"
