inherit bundle yocto-cooker

LICENSE = "CLOSED"

RAUC_BUNDLE_COMPATIBLE ?= "Gate-Up"
RAUC_BUNDLE_SLOTS ?= "rootfs"
RAUC_BUNDLE_FORMAT ?= "verity"

SRC_URI += "file://hooks"
RAUC_BUNDLE_HOOKS[file] ?= "hooks"

RAUC_SLOT_rootfs ?= "image-gate-up"
RAUC_SLOT_rootfs[type] ?= "image"
RAUC_SLOT_rootfs[fstype] ?= "ext4"
RAUC_SLOT_rootfs[rename] ?= "rootfs.ext4"
RAUC_SLOT_rootfs[hooks] ?= "post-install"

RAUC_KEY_FILE = "${THISDIR}/files/fdimatelec-gate-up.key.pem"
RAUC_CERT_FILE = "${THISDIR}/files/fdimatelec-gate-up.cert.pem"

BUNDLE_ARGS += ' --mksquashfs-args="-comp xz -Xdict-size 100%" '

# Enable building casync bundles
RAUC_CASYNC_BUNDLE = "1"
# To sign bundle (needed for casync)
RAUC_KEYRING_FILE ?= "${COREBASE}/../meta-gate-up/recipes-core/rauc/rauc/keyring.pem"
# TODO Revoir la génération de clé pour partir propre car keyring.pem est la meme que rauc, et c'est pas forcément la démarche à avoir
