#!/bin/sh

# some more ls aliases
alias ll='ls -alF'
alias la='ls -A'
alias l='ls -CF'

alias find-bak="find * -name *.bak"

alias find-name="find * -name"

alias PATH-ROOT="PATH=/usr/local/bin:/usr/bin:/bin:/usr/local/sbin:/usr/sbin:/sbin"

function yokis_service()
{
	HINT="Usage: ${FUNCNAME[0]} <SERVICE> <COMMAND>"
	SERVICE1=$1
	COMMAND2=$2

	if [ ! -z "$SERVICE1" ] && [ ! -z "$COMMAND2" ]; then
		sudo systemctl $COMMAND2 $SERVICE1
	else
		echo [${FUNCNAME[0]} $SERVICE1 $COMMAND2]
		echo
		echo $HINT
	fi
}

alias yokis-service-v5="yokis_service iot_yokis.service"
alias yokis-service-commander="yokis_service yk-commander.service"
alias yokis-service-zigbee="yokis_service yk-zigbee.service"
