SUMMARY = "Simple C library for easily using the common Open-sourceS"

HOMEPAGE = "https://github.com/lankahsu520/utilx9"

LICENSE = "BSD-3-Clause"

SECTION = "libs"

DEPENDS = " \
	openssl \
	zlib \
	libuv \
	expat \
	jansson \
	curl \
	dbus \
	libusb1 \
	"

# remove apache2
#DEPENDS += " \
#	apache2 \
#	apr \
#	apr-util \
#	pcre \
#	"

#DEPENDS += " \
#	mosquitto \
#	libwebsockets \
#	"

# BlueZ
DEPENDS += " \
	glib-2.0 \
	readline \
	"

DEPENDS += " \
	libyuarel \
	"

SRC_URI = " \
	https://codeload.github.com/lankahsu520/utilx9/tar.gz/refs/tags/v${PV};downloadfilename=utilx9-1.2.1.tar.gz \
	file://utilx9-${PV}/confs/config.conf \
	file://utilx9-${PV}/confs/build_env.sh \
	file://utilx9-${PV}/confs/common/install.conf \
	file://utilx9-${PV}/confs/common/xflags.conf \
	file://utilx9-${PV}/define.mk \
	file://utilx9-${PV}/library.mk \
	file://utilx9-${PV}/Makefile \
	"

SRC_URI[md5sum] = "1dce838498a1c83375951649b664e8c8"
#SRC_URI[sha256sum] = ""

LIC_FILES_CHKSUM = " \
	file://LICENSE;md5=a828cf528fac643fcfef67d9304b685b \
	"

S = "${WORKDIR}/utilx9-${PV}"

export PJ_ROOT="${S}"
export HOMEX_ROOT_DIR="${D}"
export SDK_CONFIG_CONFIG="${PJ_ROOT}/include/config_customer"
export CFLAGS_DBUS="-I${PKG_CONFIG_SYSROOT_DIR}/usr/include/dbus-1.0 -I${PKG_CONFIG_SYSROOT_DIR}/usr/lib/dbus-1.0/include"

FILES:${PN} += "usr/*"
#FILES:${PN} += "${bindir}/* ${libdir}/*"
#FILES:${PN}-dev = "${includedir}/*"

do_configure:append() {
	. ${PJ_ROOT}/confs/build_env.sh

	. ${PJ_ROOT}/confs/config.conf
	. ${PJ_ROOT}/confs/customer2def.sh

	export > ${S}/export_configure.log

	oe_runmake .configured
}

do_compile() {
	. ${PJ_ROOT}/confs/config.conf
	export > ${S}/export_compile.log

	oe_runmake
}

do_install() {
	. ${PJ_ROOT}/confs/config.conf
	export > ${S}/export_install.log

	oe_runmake romfs
}

INSANE_SKIP_${PN}:append = "already-stripped"

# fix
# ERROR: hello-3-r0 do_package_qa: QA Issue: File /usr/bin/helloYocto in package hello doesn't have GNU_HASH (didn't pass LDFLAGS?) [ldflags]
# Set LDFLAGS options provided by the build system
TARGET_CC_ARCH += "${LDFLAGS}"