SUMMARY = "Simple C library for parsing URLs with zero-copy and no mallocs."

DESCRIPTION = "Very simple and well tested C library for parsing URLs with zero-copy and no mallocs."

HOMEPAGE = "https://github.com/jacketizer/libyuarel"

LICENSE = "MIT"

SECTION = "libs"

DEPENDS = ""

SRC_URI = "https://codeload.github.com/jacketizer/libyuarel/tar.gz/refs/tags/1.0;downloadfilename=libyuarel-${PV}.tar.gz \
           file://0001-CC.patch"

SRC_URI[md5sum] = "81e4b87afe63a5e78194f3806c3b714e"
#SRC_URI[sha256sum] = ""

LIC_FILES_CHKSUM = "file://LICENSE;md5=264070cf57a42b260d69675fbb8aeb46 \
                    file://yuarel.h;md5=bcdcc2b6b6e3a64c54617f076755031f"

S = "${WORKDIR}/libyuarel-${PV}"

#FILES:${PN} += "${libdir}/*"
#FILES:${PN}-dev = "${libdir}/* ${includedir}"

do_compile() {
	export > ${S}/export_compile.log

	oe_runmake -f Makefile
}

do_install:append() {
	export > ${S}/export_install.log

	install -d ${D}${libdir}
	install ${S}/libyuarel.so* ${D}${libdir}
	(cd ${D}${libdir}; ln -fs libyuarel.so.1 libyuarel.so)

	install -d ${D}${includedir}
	install yuarel.h ${D}${includedir}
}

INSANE_SKIP_${PN}:append = "already-stripped"
INSANE_SKIP_${PN} = "ldflags"
INHIBIT_PACKAGE_DEBUG_SPLIT = "1"
INHIBIT_PACKAGE_STRIP = "1"

# fix
# ERROR: hello-3-r0 do_package_qa: QA Issue: File /usr/bin/helloYocto in package hello doesn't have GNU_HASH (didn't pass LDFLAGS?) [ldflags]
# Set LDFLAGS options provided by the build system
TARGET_CC_ARCH += "${LDFLAGS}"